#pragma once

/// @file
/// @brief Defines all error codes
///
/// @copyright Copyright 2023 InfoTeCS.

/// @brief List of all possible error codes that can be used
typedef enum
{
    Success = 0x00000000, ///< Success

    ErrInvalidParameter = 0x00020006,      ///< Invalid parameter

    ErrUnmergeContext = 0x00030000,        ///< Unmerge error context
    ErrKeysIntegrityFailed = 0x00030040,   ///< Failed integrity
    ErrIplircfgFailed = 0x00030200,        ///< Check iplircfg failed
    ErrKeysNotFoundInFile = 0x00030400,    ///< Keys not found
    ErrKeysUserNotRegistered = 0x00030800, ///< Selected personal key doesn't exist

    ErrDstContext = 0x00040000,     ///< DST error context
    ErrDstContextMask = 0x0004ffff, ///< Check DST error

    ErrPasswordContext = 0x00050000,        ///< Password error context
    ErrPasswordIsWrong = 0x00050001,        ///< Password is wrong
    ErrNoPasswordAttemptsLeft = 0x00050002, ///< Password attempts exceeded
    ErrPasswordIsExpired = 0x00050003,      ///< Password's expired
    ErrCriticalAuthFailure = 0x00050004,    ///< Critical auth failure
    ErrWrongLoginState = 0x00050005,        ///< Wrong login state
    ErrLoginCounterFileError = 0x00050006,  ///< Login counter file error
    ErrFinalPasswordAttempt = 0x00050008,   ///< Last password attempt

    ErrStartContext = 0x00060000,               ///< Start error context
    ErrStartKeyNotFound = 0x00060008,           ///< Key not found
    ErrStartIplircfgWrongPin = 0x000600d9,      ///< Wrong pin
    ErrStartIplircfgUserPinLocked = 0x000600e2, ///< User pin is locked

    ErrClientContext = 0x00070000,        ///< Client error context
    ErrVpnWorks = 0x00070001,             ///< VPN's up when shouldn't
    ErrVpnDoesntWork = 0x00070002,        ///< VPN's disabled when shouldn't
    ErrGetNodeList = 0x00070003,          ///< Error getting nodes list
    ErrVpnAlreadyStarted = 0x00070005,    ///< Already started for another user
    ErrGetNodeInfo = 0x00070006,          ///< Couldn't get node info
    ErrCoordinatorSetFailed = 0x00070007, ///< Failed to set active coordinator
    ErrCheckConnection = 0x00070008,      ///< Couldn't check connection
    ErrBinaryCheckFailed = 0x00070009,    ///< Binary integrity check's failed

    ErrServiceContext = 0x00090000,          ///< Service error context
    ErrServiceUserUndefined = 0x00090003,    ///< Defined VPN user doesn't exist
    ErrServiceActionCanceled = 0x00090004,   ///< User canceled action
    ErrServiceIntegrityBroken = 0x00090005,  ///< Integrity's broken
    ErrServiceDoesNotRespond = 0x00090007,   ///< Service isn't responding
    ErrServiceIsNotReady = 0x00090009,       ///< Service isn't ready
    ErrSetCapabilities = 0x00090081,         ///< Error in setting capabilities
    ErrConfigureAutorun = 0x00090083,        ///< Error in configuring autorun
    ErrServiceStop = 0x00090085,             ///< Stop error
    ErrServiceAlreadyStarted = 0x00090086,   ///< Repeated start error
    ErrServiceCanceledPassword = 0x00090089, ///< User canceled password input
    ErrDemo = 0x00090090,                    ///< Demo build is expired
    ErrRpc = 0x00090091,                     ///< RPC error
    ErrRpcIsBusy = 0x00090092,               ///< RPC server is busy
    ErrServiceUnknown = 0x000900ff,          ///< Unknown error

    ErrReportContext = 0x000c0000,      ///< Report error context
    ErrPathIsDir = 0x000c0001,          ///< The specified path is a directory
    ErrFileExists = 0x000c0002,         ///< The specified path is an existing file
    ErrPathDoesNotExist = 0x000c0003,   ///< The parent directory doesn't exist
    ErrPathIsNotAvailable = 0x000c0004, ///< The parent directory is unreachable
    ErrReportCreation = 0x000c0005,     ///< Failed to create a report

    ErrAuthContext = 0x000d0000,                ///< Authentication error context
    ErrIncorrectPinOrPswd = 0x000d0001,         ///< Incorrect params of PIN or password
    ErrLogonRequired = 0x000d0002,              ///< Operations needs logon
    ErrUpdateCredentials = 0x000d0003,          ///< Update auth credentials
    ErrContainerExists = 0x000d0004,            ///< Device already contains key container
    ErrWrongPin = 0x000d0005,                   ///< Wrong PIN
    ErrDeviceLocked = 0x000d0006,               ///< Auth device's locked
    ErrUnsupportedMode = 0x000d0007,            ///< Unsupported device mode
    ErrMemoryLack = 0x000d0008,                 ///< Device lacks memory
    ErrNoDevice = 0x000d0009,                   ///< Device is absent
    ErrKeysNotFoundOnDevice = 0x000d000a,       ///< Key info isn't found or supported
    ErrDeviceKeysAreCorrupted = 0x000d000b,     ///< Key info corruption
    ErrSystemResourceAccessDenied = 0x000d000c, ///< System resources access error
    ErrAuthInternal = 0x000d000d,               ///< Internal authentication error

    ErrProfileVpnOn = 0x00130001,               ///< VPN is active while binding or unbinding profile
    ErrProfileUnbindFailed = 0x00130002,        ///< Profile deactivation failed
    ErrProfileBindFailed = 0x00130003,          ///< Profile activation failed
    ErrProfileAliasEmpty = 0x00130004,          ///< Profile alias is empty
    ErrProfileAliasTooLong = 0x00130005,        ///< Profile alias is longer than 120 symbols
    ErrProfileAliasDuplicate = 0x00130006,      ///< Such a profile name already exists
    ErrNoProfileToSetAlias = 0x00130007,        ///< No profile to set alias
    ErrProfileAliasFailed = 0x00130008,         ///< Failed to set/unset alias
    ErrProfileNotFound = 0x00130009,            ///< Profile no found
    ErrProfileIsActive = 0x0013000a,            ///< Profile is active
    ErrProfileRemoveFailed = 0x0013000b,        ///< Failed to remove profile
    ErrNoProfileToDelete = 0x0013000c,          ///< There's no active profile to delete

    ErrInternal = 0xffffffff ///< Internal error
} VpnErrors;
