#!/bin/bash

__vipnetclient()
{
    local cur prev opts
    COMPREPLY=()
    cmd="${COMP_WORDS[1]}"
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD - 1]}"
    cmds="\
start stop installkeys deletekeys reconfigure report \
info list debug vpndiag dbviewer eventlog fw firewall \
tc transport auth profile --help --version --no-background"

    case "${cmd}" in
        start)
            pattern="--(psw|pin|token-select)"
            if [[ $prev =~ $pattern ]]; then
                COMPREPLY=()
            else
                opts="--no-failprotect --psw --pin --token-select"
                for opt in $(seq 3 $((COMP_CWORD - 1))); do
                    opts="${opts//${COMP_WORDS[$opt]}/}"
                done
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            fi
            return 0
            ;;
        stop)
            if [[ "${prev}" == "--skip-accept" ]]; then
                COMPREPLY=()
            else
                COMPREPLY=($(compgen -W "--skip-accept" -- "${cur}"))
            fi
            return 0
            ;;
        deletekeys)
            opts="--skip-accept --profile"

            if [[ "${prev}" == "--profile" ]]; then
                nodes="$(vipnetclient list --profiles 2>/dev/null | tail -n +3 | \
                    while read a b c d; do if [ "$a" = ">" ]; then printf "%s " $c; else printf "%s " $b; fi done )"
                COMPREPLY=($(compgen -W "$nodes" -- "${cur}"))
            else
                for opt in $(seq 2 $((COMP_CWORD - 1))); do
                    opts="${opts//${COMP_WORDS[$opt]}/}"
                done
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            fi
            return 0
            ;;
        reconfigure)
            COMPREPLY=()
            return 0
            ;;
        installkeys)
            if [[ $COMP_CWORD -eq 2 ]]; then
                _filedir '@(dst|ds5)'
                return 0
            fi

            pattern="--(psw|pin|token-select)"
            if [[ $prev =~ $pattern ]]; then
                COMPREPLY=()
            else
                opts="--no-autostart --no-failprotect --no-start --psw --pin --token-select"
                for opt in $(seq 3 $((COMP_CWORD - 1))); do
                    opts="${opts//${COMP_WORDS[$opt]}/}"
                done
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            fi
            return 0
            ;;
        report)
            if [[ "${prev}" == "--output" ]]; then
                _filedir
            else
                COMPREPLY=($(compgen -W "--output" -- "${cur}"))
            fi
            return 0
            ;;
        info)
            if [[ "${prev}" == "--regulations" ]]; then
                COMPREPLY=($(compgen -W "--psw" -- "${cur}"))
            elif [[ "${prev}" == "--psw" ]]; then
                COMPREPLY=()
            else
                COMPREPLY=($(compgen -W "--regulations" -- "${cur}"))
            fi
            return 0
            ;;
        list)
            pattern="--(nodes|users|tokens|profiles)"
            if [[ $prev =~ $pattern ]] || [[ $COMP_CWORD > 2 ]]; then
                COMPREPLY=()
            else
                opts="--nodes --users --tokens --profiles"
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            fi
            return 0
            ;;
        debug)
            if [[ "${prev}" == "--loglevel" || "$prev" == "--pin" || "$prev" == "--token-select" || "$prev" == "--get-client-param" ]]; then
                COMPREPLY=()
            elif [[ "${prev}" == "--active-server" ]]; then
                COMPREPLY=($(vipnetclient ${cmd} ${prev} | grep -Po "^${cur}\\w+"))
            elif [[ "${prev}" == "--user-vpnconfig" ]]; then
                _filedir '@(vpnconfig)'
            elif [[ "${prev}" == "--benchmark" ]]; then
                COMPREPLY=(1400)
            elif [[ "${prev}" == "--tcp-tunnel-mode" ]]; then
                COMPREPLY=($(compgen -W "on off auto" -- "${cur}"))
            elif [[ "${prev}" == "--ping" ]]; then
                COMPREPLY=($(vipnetclient list --nodes | tail +2 | cut -f 1 -d " " | grep -Po "^${cur}\\w+"))
            elif [[ "${COMP_WORDS[@]}" == *"--change-logon-type"* ]]; then
                opts="--pin --token-select"
                for opt in $(seq 2 $((COMP_CWORD - 1))); do
                    opts="${opts//${COMP_WORDS[$opt]}/}"
                done
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            elif [[ $COMP_CWORD == 2 ]]; then
                opts="--loglevel --mftp-reconnect --autostart --no-autostart --active-server --insist --ping \
                --benchmark --tokens --change-logon-type --tcp-tunnel-mode --reload --user-vpnconfig --get-client-param \
                --mdns --no-mdns --mdns-debug --no-mdns-debug --mdns-cache --nvs-debug \
                --no-nvs-debug --no-connect-server-group --connect-server-group --tunnel-visibility --help"
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            else
                opts="--loglevel --mftp-reconnect --autostart --no-autostart --active-server --insist --ping \
                --benchmark --tokens --tcp-tunnel-mode --reload --user-vpnconfig --get-client-param \
                --mdns --no-mdns --mdns-debug --no-mdns-debug --mdns-cache --tunnel-visibility \
                --no-connect-server-group --connect-server-group --nvs-debug --no-nvs-debug --help"
                for opt in $(seq 2 $((COMP_CWORD - 1))); do
                    opti="${COMP_WORDS[$opt]//--?(no-)/--?(no-)}"
                    opts="${opts//$opti/}"
                done
                COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
            fi
            return 0
            ;;
        vpndiag)
            if [[ $COMP_CWORD -eq 2 ]]; then
                COMPREPLY=($(compgen -W "-s" -- "${cur}"))
            elif [[ "${prev}" == "-s" ]]; then
                COMPREPLY=($(compgen -W "adapters cipher dnsproxy firewall ipsettings groupserver tpm updates" -- "${cur}"))
            elif [[ "${prev}" == "adapters" ]]; then
                COMPREPLY=($(compgen -W "--stats --info --routes --json" -- "${cur}"))
            elif [[ "${prev}" == "cipher" ]]; then
                COMPREPLY=($(compgen -W "--info --json" -- "${cur}"))
            elif [[ "${prev}" == "dnsproxy" ]]; then
                COMPREPLY=($(compgen -W "--info --query-logging --json" -- "${cur}"))
            elif [[ "${prev}" == "firewall" ]]; then
                COMPREPLY=($(compgen -W "--stats --static --ip --tcp --udp --udp-bcast --icmp --icmp-bcast --icmp-tcp --icmp-udp --icmp-icmp --wait-rule --natal-bindings --bcast-id --params --counters --used-ports --json" -- "${cur}"))
            elif [[ "${prev}" == "ipsettings" ]]; then
                COMPREPLY=($(compgen -W "--stats --v-table --v-tun-table --node-info --json" -- "${cur}"))
            elif [[ "${prev}" == "groupserver" ]]; then
                COMPREPLY=($(compgen -W "--info --json" -- "${cur}"))
            elif [[ "${prev}" == "tpm" ]]; then
                COMPREPLY=($(compgen -W "--info --json" -- "${cur}"))
            elif [[ "${prev}" == "updates" ]]; then
                COMPREPLY=($(compgen -W "--info --json" -- "${cur}"))
            elif [[ "${prev}" == "--node-info" ]]; then
                COMPREPLY=($(vipnetclient list --nodes | tail -n +2 | cut -f 1 -d " " | grep -Po "^${cur}\\w+"))
            else
                COMPREPLY=()
            fi
            return 0
            ;;
        dbviewer)
            COMPREPLY=()
            return 0
            ;;
        eventlog)
            pattern="(--(psw|output|delete)|-o)"
            if [[ $prev =~ $pattern ]]; then
                COMPREPLY=()
            else
                opts=(--output -o --delete --psw)
                for id in $(seq 2 2 $((COMP_CWORD - 1))); do
                    word="${COMP_WORDS[$id]}"
                    pattern="(--option|-o|--delete)"
                    if [[ $word =~ $pattern ]]; then
                        unset opts[0]
                        unset opts[1]
                        unset opts[2]
                    elif [[ $word == "--psw" ]]; then
                        unset opts[3]
                    fi
                done
                COMPREPLY=($(compgen -W "$(echo ${opts[@]})" -- "${cur}"))
            fi
            return 0
            ;;
        fw | firewall)
            if [[ $COMP_CWORD -eq 2 ]]; then
                COMPREPLY=($(compgen -W "--help info public protected" -- "${cur}"))
            elif [[ ${prev} == "--psw" ]]; then
                COMPREPLY=()
            elif [[ ${prev} == "--user-xml" || ${prev} == "--save-user-xml" ]]; then
                _filedir '@(xml)'
            elif [[ "${COMP_WORDS[2]}" == "public" ]]; then
                opts="--block --no-block --psw"
                for opt in $(seq 3 $((COMP_CWORD - 1))); do
                    opti="${COMP_WORDS[$opt]//--?(no-)/--?(no-)}"
                    opts="${opts//$opti/}"
                done
                COMPREPLY=($(compgen -W "$opts" -- "${cur}"))
            elif [[ "${COMP_WORDS[2]}" == "protected" ]]; then
                id=3
                opts=(--policy --no-policy --user-xml --save-user-xml --erase-user-xml --psw)
                while [ $id -lt $COMP_CWORD ]; do
                    case ${COMP_WORDS[$id]} in
                        --psw)
                            id=$((id + 2))
                            unset opts[5]
                            ;;
                        --policy | --no-policy | --erase-user-xml)
                            id=$((id + 1))
                            unset opts[0]
                            unset opts[1]
                            unset opts[2]
                            unset opts[3]
                            unset opts[4]
                            ;;
                        --user-xml | --save-user-xml)
                            id=$((id + 2))
                            unset opts[0]
                            unset opts[1]
                            unset opts[2]
                            unset opts[3]
                            unset opts[4]
                            ;;
                        *) break ;;
                    esac
                done
                COMPREPLY=($(compgen -W "$(echo ${opts[@]})" -- "${cur}"))
            else
                COMPREPLY=()
            fi
            return 0
            ;;
        tc | transport)
            if [[ $COMP_CWORD -eq 2 ]]; then
                COMPREPLY=($(compgen -W "--help peep events cms" -- "${cur}"))
            elif [[ "${COMP_WORDS[2]}" == "cms" ]]; then
                _filedir '@(ctl|bin)'
            elif [[ "${prev}" == "events" ]]; then
                COMPREPLY=($(compgen -W "--records" -- "${cur}"))
            else
                COMPREPLY=()
            fi
            return 0
            ;;
        auth)
            if [[ $COMP_CWORD -eq 2 ]]; then
                COMPREPLY=($(compgen -W "--change-user-password" -- "${cur}"))
            elif [[ "${COMP_WORDS[2]}" == "--change-user-password" ]]; then
                id=3
                opts=(--user-psw --new-psw --confirm)
                while [ $id -lt $COMP_CWORD ]; do
                    case ${COMP_WORDS[$id]} in
                        --user-psw)
                            id=$((id + 1))
                            unset opts[0]
                            ;;
                        --new-psw)
                            id=$((id + 1))
                            unset opts[1]
                            ;;
                        --confirm)
                            id=$((id + 1))
                            unset opts[2]
                            ;;
                        *) break ;;
                    esac
                done
                COMPREPLY=($(compgen -W "$(echo ${opts[@]})" -- "${cur}"))
            else
                COMPREPLY=()
            fi
            return 0
            ;;
        profile)
            if [[ $COMP_CWORD -eq 2 ]]; then
                COMPREPLY=($(compgen -W "--help switch set" -- "${cur}"))
                return 0
            fi

            case "${COMP_WORDS[2]}" in
               "switch")
                    nodes="$(vipnetclient list --profiles 2>/dev/null | tail -n +3 | \
                        while read a b c; do [ "$a" = "active:" ] || printf "%s " $b; done )"
                    COMPREPLY=($(compgen -W "$nodes" -- "${cur}"))                    
                    ;;
               "set")
                    id=3
                    opts=(--alias --no-alias)
                    while [ $id -lt $COMP_CWORD ]; do
                        case ${COMP_WORDS[$id]} in
                            --alias)
                                id=$((id + 2))
                                unset opts[0]
                                unset opts[1]
                                ;;
                            --no-alias)
                                id=$((id + 1))
                                unset opts[0]
                                unset opts[1]
                                ;;
                            *) break ;;
                       esac
                   done
                   COMPREPLY=($(compgen -W "$(echo ${opts[@]})" -- "${cur}"))
                   ;;
               *);;
            esac
            return 0
            ;;
        *) ;;
    esac

    opts="--help --version --no-background"

    if [[ ${cur} == -* ]]; then
        COMPREPLY=($(compgen -W "${opts}" -- "${cur}"))
        return 0
    fi

    COMPREPLY=($(compgen -W "${cmds}" -- "${cur}"))
    return 0
}

complete -F __vipnetclient vipnetclient
